//EX 10 Program Title:To find operating points and transfer curve of FET for fixed bias. 
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
//////////////////////////////////////////////////////////////////
disp('For FET Fixed Bias Circuit:' );
IDSS_1=input('Enter the value of Maxi.Drain to Sourse Current in mA   IDSS:');//Note:Press enter/
Vp=input('Enter the value of Pinch off voltage in Volt(-Ve)         Vp:');//Note:Press enter/// pinch off voltage is negative
RD_1=input('Enter the value of Drain resistance  in Kilo Ohms       RD:');//Note:Press enter///
VGG=input('Enter the value of Gate supply Voltage in volt(-Ve)    VGG:');//Note:Press enter///Gate supply voltage is negative
VDD=input('Enter the value of Drain supply Voltage in volt         VDD:');//Note:Press enter///Gate supply voltage is negative
mprintf('\n.*******************************************************\');
disp('Given data for FET Fixed Bias is:' );
IDSS=IDSS_1*1e-3   // mili amperes  Maxi Drain to Source Current
RD=RD_1*1e3   // kilo ohm   Emitter Resistance
mprintf(' Maximum Drain Current    IDSS:%.3fA',IDSS);
mprintf('\n Pinch-off voltage        Vp:%2dV',Vp);
mprintf('\n Drain Resistance         RD:%2dOhms',RD);
mprintf('\n Supply Voltage           VDD:%2dV',VDD);
mprintf('\n Gate Supply Voltage      VGG:%.1fV',VGG);
//////////////////Voltage at Secondary//////////////////////////////////
mprintf('\n.*******************************************************\');
mprintf('\n ****Shockley Equation:ID=IDSS*(1-VGS/VP)^2**************');//Shockley Equation
mprintf('\n. \*******************************************************\ \n ');
VGS=[0:-0.01:Vp];
ID=IDSS*(1-VGS/Vp).^2; //drain current using shockley equation
figure(2),plot(VGS,ID,'red');// plot of transfer characteristics
xtitle("Transfer characteristics of FET","VGS (V)","ID (mA)");
////////////////////Calculatin of VDSQ  and IDQ////////////////////////
VGSQ=VGG;
IDQ=IDSS*(1-VGSQ/Vp).^2; // Drain Current Calculation
VDSQ=VDD-(IDQ*RD);        // Drain to Sourse voltage Calculation
IDQ=IDQ*1e3;      /// mili ampere conversion
mprintf('1)Operating Point Drain To Source Voltage    VDSQ:%.2f V',VDSQ);//Display
mprintf('\n 2)Operating Point Drain Current              IDQ:%.2f mA',IDQ);
mprintf('\n. \*******************************************************\');

//Output///
//For FET Fixed Bias Circuit:   
//Enter the value of Maxi.Drain to Sourse Current in mA   IDSS:12
//Enter the value of Pinch off voltage in Volt(-Ve)         Vp:-4
//Enter the value of Drain resistance  in Kilo Ohms       RD:1.2
//Enter the value of Gate supply Voltage in volt(-Ve)      VGG:-1.5
//Enter the value of Drain supply Voltage in volt         VDD:12

//.*******************************************************
//Given data for FET Fixed Bias is:   
// Maximum Drain Current    IDSS:0.012A
 //Pinch-off voltage        Vp:-4V
// Drain Resistance         RD:1200Ohms
 //Supply Voltage           VDD:12V
 //Gate Supply Voltage      VGG:-1.5V
//.*******************************************************
// ****Shockley Equation:ID=IDSS*(1-VGS/VP)^2**************
//. ******************************************************* 
// 1)Operating Point Drain To Source Voltage    VDSQ:6.38 V
// 2)Operating Point Drain Current              IDQ:4.69 mA
//. ******************************************************* 
